<?php
include("header-test.php");
if (isset($_POST['submit'])) {
    $phoneNumber = $_POST['phoneNumber'];
    if (preg_match("/^03[0-9]{9}$/", $phoneNumber)) {
        // Process the form data
    } else {
        // Return an error message
        echo '<script>alert("Invalid phone number. Phone number should start with 03 and must be 10 digits long.");</script>';
    }
}
?>
<!DOCTYPE html>
<html>
<head>
    <title>Phone Number Validation</title>
</head>
<body>
    <form method="post" onsubmit="return validatePhoneNumber()">
        <label>Phone Number:</label>
        <input type="tel" name="phoneNumber" id="phoneNumber" pattern="03[0-9]{9}" placeholder="03XXXXXXXXX">
        <span id="errorMessage"></span>
        <input type="submit" name="submit" value="Submit">
    </form>
    <script>
        function validatePhoneNumber() {
            var phoneNumber = document.getElementById("phoneNumber").value;
            var pattern = /^03[0-9]{9}$/;
            var errorMessage = document.getElementById("errorMessage");

            if (phoneNumber.match(pattern)) {
                return true;
            } else {
                errorMessage.innerHTML = "Invalid phone number. Phone number should start with 03 and must be 10 digits long.";
                return false;
            }
        }
    </script>
</body>
</html>
